<?php
class ControllerExtensionModuleFhAccordionBuilder extends Controller {
    private $error = [];

    public function index() {
        $this->load->language('extension/module/fh_accordion_builder');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('setting/module');
        $this->load->model('setting/setting');

        $user_token = $this->session->data['user_token'] ?? '';

        // Save
        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validate()) {
            if (!isset($this->request->get['module_id'])) {
                $this->model_setting_module->addModule('fh_accordion_builder', $this->request->post);
            } else {
                $this->model_setting_module->editModule((int)$this->request->get['module_id'], $this->request->post);
            }
            $this->session->data['success'] = $this->language->get('text_success');
            $this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $user_token . '&type=module', true));
            return;
        }

        // Breadcrumbs
        $data['breadcrumbs'] = [];
        $data['breadcrumbs'][] = [
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $user_token, true)
        ];
        $data['breadcrumbs'][] = [
            'text' => $this->language->get('text_extension'),
            'href' => $this->url->link('marketplace/extension', 'user_token=' . $user_token . '&type=module', true)
        ];

        if (!isset($this->request->get['module_id'])) {
            $data['breadcrumbs'][] = [
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('extension/module/fh_accordion_builder', 'user_token=' . $user_token, true)
            ];
            $data['action'] = $this->url->link('extension/module/fh_accordion_builder', 'user_token=' . $user_token, true);
        } else {
            $module_id = (int)$this->request->get['module_id'];
            $data['breadcrumbs'][] = [
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('extension/module/fh_accordion_builder', 'user_token=' . $user_token . '&module_id=' . $module_id, true)
            ];
            $data['action'] = $this->url->link('extension/module/fh_accordion_builder', 'user_token=' . $user_token . '&module_id=' . $module_id, true);
        }
        $data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $user_token . '&type=module', true);

        // Load existing instance
        if (isset($this->request->get['module_id']) && $this->request->server['REQUEST_METHOD'] != 'POST') {
            $module_info = $this->model_setting_module->getModule((int)$this->request->get['module_id']);
        } else {
            $module_info = [];
        }

        // === 載入主題設定（若存在 theme_futurehost） ===
        $theme_settings = $this->model_setting_setting->getSetting('theme_futurehost');
        $theme_config   = $theme_settings['theme_futurehost'] ?? [];

        // === 語系 ===
        $data['heading_title'] = $this->language->get('heading_title');
        $data['text_edit']     = $this->language->get('text_edit');
        $data['text_enabled']  = $this->language->get('text_enabled');
        $data['text_disabled'] = $this->language->get('text_disabled');

        $data['text_style_simple'] = $this->language->get('text_style_simple');
        $data['text_style_border'] = $this->language->get('text_style_border');
        $data['text_style_filled'] = $this->language->get('text_style_filled');
        $data['text_style_shadow'] = $this->language->get('text_style_shadow');

        $data['entry_name']       = $this->language->get('entry_name');
        $data['entry_status']     = $this->language->get('entry_status');
        $data['entry_heading']    = $this->language->get('entry_heading');
        $data['entry_style']      = $this->language->get('entry_style');
        $data['entry_open_first'] = $this->language->get('entry_open_first');
        $data['entry_multiple']   = $this->language->get('entry_multiple');
        $data['entry_items']      = $this->language->get('entry_items');
        $data['entry_title']      = $this->language->get('entry_title');
        $data['entry_content']    = $this->language->get('entry_content');
        $data['entry_colors']     = $this->language->get('entry_colors');
        $data['entry_color_accent'] = $this->language->get('entry_color_accent');
        $data['entry_color_title']   = $this->language->get('entry_color_title');
        $data['entry_color_text']    = $this->language->get('entry_color_text');
        $data['entry_color_bg']      = $this->language->get('entry_color_bg');
        $data['entry_color_border']  = $this->language->get('entry_color_border');

        $data['button_add_item']  = $this->language->get('button_add_item');
        $data['button_remove']    = $this->language->get('button_remove');
        $data['button_save']      = $this->language->get('button_save');
        $data['button_cancel']    = $this->language->get('button_cancel');

       // === 預設值（含主題顏色） ===
        $defaults = [
            'name'        => '手風琴內容模組',
            'status'      => 1,
            'heading'     => '常見問題 / 內容區塊',
            'style'       => 'border',
            'open_first'  => 1,
            'multiple'    => 0,
            'items'       => [
                ['title' => '區塊標題 A', 'content' => '<p>這裡是內容 A（支援 HTML / 圖片 / 連結）。</p>'],
                ['title' => '區塊標題 B', 'content' => '<p>這裡是內容 B，可以當作 QA 或服務說明。</p>']
            ],

            // === 顏色來自主題設定（如果有就覆蓋預設） ===
            'color_title'    => $theme_conf['color_primary']    ?? '#4E7A94',
            'color_text'  => $theme_conf['text_muted']      ?? '#6c757d',
            'color_accent' => $theme_conf['color_secondary'] ?? '#729FDA',
            'color_bg'     => $theme_conf['bg_card_default'] ?? '#ffffff',
            'color_border'   => $theme_conf['color_border']    ?? '#e6e6e6',
        ];

        foreach ($defaults as $k => $v) {
            $data[$k] = $this->request->post[$k] ?? ($module_info[$k] ?? $v);
        }

        // === 錯誤提示 ===
        $data['error_warning'] = $this->error['warning'] ?? '';
        $data['error_name']    = $this->error['name'] ?? '';
        $data['error_items']   = $this->error['items'] ?? '';

        // === 共用區塊 ===
        $data['header']      = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer']      = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/module/fh_accordion_builder', $data));
    }

    protected function validate() {
        if (!$this->user->hasPermission('modify', 'extension/module/fh_accordion_builder')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        $name = $this->request->post['name'] ?? '';
        if (utf8_strlen($name) < 3 || utf8_strlen($name) > 64) {
            $this->error['name'] = $this->language->get('error_name');
        }

        $items = $this->request->post['items'] ?? [];
        $has = false;
        if (is_array($items)) {
            foreach ($items as $it) {
                if (!empty($it['title'])) { $has = true; break; }
            }
        }
        if (!$has) {
            $this->error['items'] = $this->language->get('error_items');
        }

        return !$this->error;
    }

    public function install() {}
    public function uninstall() {}
}
