<?php
class ControllerExtensionModuleFhCategoryProduct extends Controller
{
    private $error = [];

    public function index()
    {
        $this->load->language('extension/module/fh_category_product');
        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/module');
        $this->load->model('catalog/category');
        
        $user_token = $this->session->data['user_token'] ?? '';

        // 儲存設定
        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validate()) {
            if (!isset($this->request->get['module_id'])) {
                $this->model_setting_module->addModule('fh_category_product', $this->request->post);
            } else {
                $this->model_setting_module->editModule($this->request->get['module_id'], $this->request->post);
            }
            $this->session->data['success'] = $this->language->get('text_success');
            $this->response->redirect(
                $this->url->link('marketplace/extension', 'user_token=' . $user_token . '&type=module', true)
            );
            return;
        }

        // Header / Sidebar / Footer
        $data['header']      = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer']      = $this->load->controller('common/footer');

        // 語系文字
        $lang_keys = [
            'heading_title',
            'text_edit',
            'text_enabled',
            'text_disabled',
            'text_grid',
            'text_list',
            'entry_name',
            'entry_status',
            'entry_heading',
            'entry_category',
            'entry_sort',
            'entry_template',
            'button_save',
            'button_cancel',
        ];
        foreach ($lang_keys as $key) {
            $data[$key] = $this->language->get($key);
        }

        // 麵包屑
        $data['breadcrumbs'] = [];
        $data['breadcrumbs'][] = [
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $user_token, true)
        ];
        $data['breadcrumbs'][] = [
            'text' => $this->language->get('text_extension'),
            'href' => $this->url->link('marketplace/extension', 'user_token=' . $user_token . '&type=module', true)
        ];

        if (!isset($this->request->get['module_id'])) {
            $data['breadcrumbs'][] = [
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('extension/module/fh_category_product', 'user_token=' . $user_token, true)
            ];
            $data['action'] = $this->url->link('extension/module/fh_category_product', 'user_token=' . $user_token, true);
        } else {
            $data['breadcrumbs'][] = [
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('extension/module/fh_category_product', 'user_token=' . $user_token . '&module_id=' . (int)$this->request->get['module_id'], true)
            ];
            $data['action'] = $this->url->link('extension/module/fh_category_product', 'user_token=' . $user_token . '&module_id=' . (int)$this->request->get['module_id'], true);
        }

        $data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $user_token . '&type=module', true);

        // 載入現有設定
        $module_info = [];
        if (isset($this->request->get['module_id']) && $this->request->server['REQUEST_METHOD'] != 'POST') {
            $module_info = $this->model_setting_module->getModule($this->request->get['module_id']);
        }

        // 分類清單
        $data['categories'] = $this->model_catalog_category->getCategories([]);

        // 欄位預設值（極簡）
        $fields = [
            'name'        => '分類商品清單',
            'status'      => 1,
            'heading'     => '精選商品',
            'category_id' => 0,
            'sort'        => 'pd.name-ASC',
            'template'    => 'grid',
        ];
        foreach ($fields as $key => $value) {
            $data[$key] = $this->request->post[$key] ?? ($module_info[$key] ?? $value);
        }

        // 錯誤訊息
        $data['error_warning'] = $this->error['warning'] ?? '';
        $data['error_name']    = $this->error['name'] ?? '';
        $data['error_category']= $this->error['category'] ?? '';

        $data['user_token'] = $user_token;

        $this->response->setOutput($this->load->view('extension/module/fh_category_product', $data));
    }

    protected function validate()
    {
        if (!$this->user->hasPermission('modify', 'extension/module/fh_category_product')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        if (
            !isset($this->request->post['name']) ||
            utf8_strlen($this->request->post['name']) < 3 ||
            utf8_strlen($this->request->post['name']) > 64
        ) {
            $this->error['name'] = $this->language->get('error_name');
        }

        if (!isset($this->request->post['category_id']) || (int)$this->request->post['category_id'] < 1) {
            $this->error['category'] = $this->language->get('error_category');
        }

        return !$this->error;
    }

    public function install()
    {
        $this->load->model('user/user_group');
        $this->model_user_user_group->addPermission($this->user->getGroupId(), 'access', 'extension/module/fh_category_product');
        $this->model_user_user_group->addPermission($this->user->getGroupId(), 'modify', 'extension/module/fh_category_product');

        $this->load->model('setting/setting');
        $this->model_setting_setting->editSetting('module_fh_category_product', [
            'module_fh_category_product_status' => 1,
        ]);
    }

    public function uninstall() {}
}
