(function () {
  function openFileManager($el) {
    var target = $el.parent().find('input').attr('id');
    var thumb  = $el.attr('id');

    $('#modal-image').remove();

    $.ajax({
      url: 'index.php?route=common/filemanager&user_token=' + getURLVar('user_token')
          + (target ? '&target=' + encodeURIComponent(target) : '')
          + (thumb  ? '&thumb='  + encodeURIComponent(thumb)  : ''),
      dataType: 'html',
      success: function (html) {
        $('body').append('<div id="modal-image" class="modal">' + html + '</div>');
        $('#modal-image').modal('show');
      },
      error: function (xhr, s, err) { alert(err + "\n" + xhr.statusText); }
    });
  }

  // 用捕獲階段攔截點擊，避免被其他 handler 蓋掉
  document.addEventListener('click', function (ev) {
    var a = ev.target.closest && ev.target.closest('a[data-toggle="image"]');
    if (!a) return;

    ev.preventDefault();
    ev.stopPropagation();
    ev.stopImmediatePropagation();

    var $a = $(a);
    $('a[data-toggle="image"]').popover('destroy');

    if ($a.data('bs.popover')) return;

    $a.popover({
      html: true, sanitize: false, placement: 'right', trigger: 'manual',
      content: function () {
        return '' +
          '<button type="button" id="button-image" class="btn btn-primary" title="選擇圖片"><i class="fa fa-pencil"></i></button> ' +
          '<button type="button" id="button-clear" class="btn btn-danger"  title="清除"><i class="fa fa-trash-o"></i></button>';
      }
    }).popover('show');

    setTimeout(function () {
      $('#button-image').off('click').on('click', function () {
        var $btn = $(this), $icon = $btn.find('> i');
        $btn.prop('disabled', true);
        if ($icon.length) $icon.attr('class','fa fa-circle-o-notch fa-spin');

        openFileManager($a);

        setTimeout(function(){
          $btn.prop('disabled', false);
          if ($icon.length) $icon.attr('class','fa fa-pencil');
        }, 400);

        $a.popover('destroy');
      });

      $('#button-clear').off('click').on('click', function () {
        $a.find('img').attr('src', $a.find('img').attr('data-placeholder'));
        $a.parent().find('input').val('');
        $a.popover('destroy');
      });
    }, 80);
  }, true); // << 捕獲階段
})();
