<?php
class ControllerExtensionModuleFhAccordionBuilder extends Controller {
    public function index($setting) {
        // 模組未啟用 → 不輸出
        if (empty($setting['status'])) return '';

        // === 區塊設定 ===
        $data['heading']    = $setting['heading'] ?? '';
        $data['style']      = $setting['style'] ?? 'border';
        $data['open_first'] = !empty($setting['open_first']);
        $data['multiple']   = !empty($setting['multiple']);

        // === 主題色設定（與後台命名一致） ===
        $data['colors'] = [
            'accent' => $setting['color_accent'] ?? '#0a7cff',
            'title'  => $setting['color_title']  ?? '#222222',
            'text'   => $setting['color_text']   ?? '#666666',
            'bg'     => $setting['color_bg']     ?? '#ffffff',
            'border' => $setting['color_border'] ?? '#e5e5e5',
        ];

        // === 項目列表 ===
        $items = [];
        if (!empty($setting['items']) && is_array($setting['items'])) {
            foreach ($setting['items'] as $it) {
                $title = trim($it['title'] ?? '');
                $content = trim($it['content'] ?? '');

                if ($title !== '') {
                    $items[] = [
                        'title'   => $title,
                        // HTML 內容安全解碼
                        'content' => html_entity_decode($content, ENT_QUOTES, 'UTF-8'),
                    ];
                }
            }
        }

        // 無項目 → 不輸出
        if (!$items) return '';

        // === 前端資料 ===
        $data['items'] = $items;
        $data['uid'] = substr(md5(json_encode($setting) . microtime(true)), 0, 8);

        // === 載入視圖 ===
        return $this->load->view('extension/module/fh_accordion_builder', $data);
    }
}
