<?php
class ControllerExtensionModuleFhCategoryProduct extends Controller
{
    public function index($setting)
    {
        if (empty($setting['status'])) return '';

        $this->load->language('extension/module/fh_category_product');
        $this->load->model('catalog/product');
        $this->load->model('tool/image');
        $this->load->model('setting/setting');

        $theme_settings = $this->model_setting_setting->getSetting('theme_futurehost');
        $theme_config = $theme_settings['theme_futurehost'] ?? [];

        $category_id = (int)($setting['category_id'] ?? 0);
        $sort_conf   = $setting['sort'] ?? 'pd.name-ASC';
        $heading     = $setting['heading'] ?? $this->language->get('heading_default');
        $template    = $setting['template'] ?? 'grid';

        $image_w = (int)($theme_config['image_product_width']  ?? 228);
        $image_h = (int)($theme_config['image_product_height'] ?? 228);
        $limit   = (int)($theme_config['product_limit']        ?? 15);

        $parts = explode('-', $sort_conf);
        $sort  = $parts[0] ?? 'pd.name';
        $order = $parts[1] ?? 'ASC';

        $filter_data = [
            'filter_category_id' => $category_id,
            'sort'               => $sort,
            'order'              => $order,
            'start'              => 0,
            'limit'              => $limit
        ];

        $results = $this->model_catalog_product->getProducts($filter_data);

        if (!$results) return '';

        $data = [
            'heading'  => $heading,
            'template' => $template,
            'products' => []
        ];

        foreach ($results as $result) {
            $thumb = $result['image']
                ? $this->model_tool_image->resize($result['image'], $image_w, $image_h)
                : $this->model_tool_image->resize('placeholder.png', $image_w, $image_h);

            $data['products'][] = [
                'product_id' => $result['product_id'],
                'thumb'      => $thumb,
                'name'       => $result['name'],
                'price'      => $result['price'] ? $this->currency->format($result['price'], $this->session->data['currency']) : false,
                'special'    => $result['special'] ? $this->currency->format($result['special'], $this->session->data['currency']) : false,
                'rating'     => isset($result['rating']) ? (int)$result['rating'] : 0,
                'href'       => $this->url->link('product/product', 'product_id=' . $result['product_id'])
            ];
        }
        return $this->load->view('extension/module/fh_category_product', $data);
    }
}
