<?php
class ControllerExtensionModuleFuturehostMenu extends Controller {
    // public function index($route = '', $args = [], &$output = '') {
    //     try {
    //         // === 載入必要 model ===
    //         $this->load->model('catalog/category');

    //         // === 建立資料 ===
    //         $data['items_desktop'] = $this->buildCategoryMenu('desktop');
    //         $data['items_mobile']  = $this->buildCategoryMenu('mobile');
    
    //         $server = !empty($this->request->server['HTTPS'])
    //             ? $this->config->get('config_ssl')
    //             : $this->config->get('config_url');
    
    //         $data['home']          = $this->url->link('common/home');
    //         $data['name']          = $this->config->get('config_name');
    //         $data['logo']          = is_file(DIR_IMAGE . $this->config->get('config_logo'))
    //             ? $server . 'image/' . $this->config->get('config_logo')
    //             : '';
    //         $data['account']       = $this->url->link('account/login', '', true);
    //         $data['shopping_cart'] = $this->url->link('checkout/cart');
    //         $data['contact']       = $this->url->link('information/contact');
    //         $data['language']      = $this->load->controller('common/language');
    //         $data['cart']          = $this->load->controller('common/cart');

    //         // === 載入現有模板 ===
    //         // 📌 這裡改為你的實際檔案路徑 common/menu.twig
    //         $menu_html = $this->load->view('common/menu', $data);

    //         // === 插入到頁面輸出 ===
    //         if (preg_match('/<body[^>]*>/i', $output)) {
    //             $output = preg_replace('/(<body[^>]*>)/i', "$1\n{$menu_html}", $output, 1);
    //             // $header_controller = $this->load->controller('common/header');
    //             // $output = $header_controller . $menu_html;
    //             error_log('[FutureHost Menu] Injected inside <body>');
    //         } else {
    //             $output = $menu_html . $output;
    //             error_log('[FutureHost Menu] Injected at beginning (no <body>)');
    //         }
    //     } catch (\Throwable $e) {
    //         error_log('[FutureHost Menu ERROR] ' . $e->getMessage() . ' in ' . $e->getFile() . ':' . $e->getLine());
    //     }
    // }
    public function index() {
        // if ($this->config->get('config_seo_url')) {
        //     $this->load->controller('startup/seo_url');
        // }
        $this->load->model('catalog/category');

        $data['items_desktop'] = $this->buildCategoryMenu('desktop');
        $data['items_mobile']  = $this->buildCategoryMenu('mobile');

        $server = !empty($this->request->server['HTTPS'])
            ? $this->config->get('config_ssl')
            : $this->config->get('config_url');

        $data['home']          = $this->url->link('common/home');
        $data['name']          = $this->config->get('config_name');
        $data['logo']          = is_file(DIR_IMAGE . $this->config->get('config_logo'))
            ? $server . 'image/' . $this->config->get('config_logo')
            : '';
        $data['account']       = $this->url->link('account/login', '', true);
        $data['shopping_cart'] = $this->url->link('checkout/cart');
        $data['contact']       = $this->url->link('information/contact');
        $data['language']      = $this->load->controller('common/language');
        $data['cart']          = $this->load->controller('common/cart');


        // ✅ 回傳 HTML 給其他控制器使用（不給事件直接 return）
        return $this->load->view('common/menu', $data);
    }

    private function buildCategoryMenu(string $for = 'desktop'): array {
        $useCustom = 1;

        // 自訂分類
        if ($useCustom) {
            $home   = $this->url->link('common/home');
            $allProducts = $this->url->link('product', 'path=33'); // category_id=33 -> keyword=product
            $about       = $this->url->link('information/about');
            $info   = function (int $id) {
                return $this->url->link('information/information', 'information_id=' . (int)$id);
            };
            $learnChildren = [
                ['label' => '香氛蠟燭保養', 'href' => $info(7)],
                ['label' => '香氣配方解析', 'href' => $info(7)],
                ['label' => '居家香氛搭配', 'href' => $info(7)],
                ['label' => '精油基礎知識', 'href' => $info(7)],
            ];
            $storeChildren = [
                ['label' => '北部通路', 'href' => $info(7)],
                ['label' => '中部通路', 'href' => $info(7)],
                ['label' => '南部通路', 'href' => $info(7)],
            ];

            if ($for === 'mobile') {
                return [
                    ['label' => '官網首頁', 'href' => $home],
                    ['label' => '所有商品', 'href' => $allProducts],
                    // [
                    //     'label' => '精選商品',
                    //     'href'  => $allProducts,
                    //     'children' => [
                    //         ['label' => '虛擬主機', 'href' => $this->url->link('product/category', 'path=33_45')],
                    //         ['label' => 'VPS 主機', 'href' => $this->url->link('product/category', 'path=33_46')],
                    //     ],
                    // ],
                    ['label' => '品牌故事', 'href' => $about],
                    ['label' => '香芬知識堂', 'href' => 'javascript:void(0);', 'children' => $learnChildren],
                    ['label' => '實體通路據點',   'href' => 'javascript:void(0);', 'children' => $storeChildren],
                    ['label' => '聯絡我們', 'href' => $this->url->link('information/contact')],
                ];
            } else {
                // 自訂桌機版選單
                return [
                ['label' => '官網首頁', 'href' => $home],
                ['label' => '所有商品', 'href' => $allProducts],
                ['label' => '品牌故事', 'href' => $about],
                ['label' => '香氛知識學堂', 'href' => 'javascript:void(0);', 'children' => $learnChildren],
                ['label' => '香氛體驗據點',   'href' => 'javascript:void(0);', 'children' => $storeChildren],
                ['label' => '聯絡我們', 'href' => $this->url->link('information/contact')],
            ];
            }
        }

        // 預設資料庫分類
        $items = [];
        $parents = $this->model_catalog_category->getCategories(0);

        foreach ($parents as $p) {
            if (empty($p['category_id']) || empty($p['name'])) continue;

            $parent_id = (int)$p['category_id'];
            $parent = [
                'label'    => $p['name'],
                'href'     => $this->url->link('product/category', 'path=' . $parent_id),
                'children' => []
            ];

            $children = $this->model_catalog_category->getCategories($parent_id);
            foreach ($children as $c) {
                if (empty($c['category_id']) || empty($c['name'])) continue;

                $child_id = (int)$c['category_id'];
                $parent['children'][] = [
                    'label' => $c['name'],
                    'href'  => $this->url->link('product/category', 'path=' . $parent_id . '_' . $child_id),
                ];
            }

            $items[] = $parent;
        }

        return $items;
    }
}