/* ===========================
   Product Page Interaction
   =========================== */

// 縮圖切換主圖 + 自動置中
document.querySelectorAll('.thumb-item').forEach(img => {
  img.addEventListener('click', e => {
    const main = document.querySelector('#main-product-image');
    const track = document.querySelector('.thumb-track');
    if (!main || !track) return;

    main.src = e.target.dataset.full;
    document.querySelectorAll('.thumb-item').forEach(t => t.classList.remove('active'));
    e.target.classList.add('active');

    // 置中
    const rect = e.target.getBoundingClientRect();
    const offset = rect.left - (window.innerWidth / 2) + rect.width / 2;
    track.scrollBy({ left: offset, behavior: 'smooth' });
  });
});

// 數量加減
const qtyInput = document.querySelector('#input-quantity');
if (qtyInput) {
  const plusBtn = document.querySelector('.qty-btn.plus');
  const minusBtn = document.querySelector('.qty-btn.minus');
  if (plusBtn && minusBtn) {
    plusBtn.addEventListener('click', () => qtyInput.value = parseInt(qtyInput.value || 1) + 1);
    minusBtn.addEventListener('click', () => qtyInput.value = Math.max(1, parseInt(qtyInput.value || 1) - 1));
  }
}

// 拖曳滑動 (滑鼠 + 觸控)
(function () {
  const track = document.querySelector('.drag-scroll');
  if (!track) return;
  let isDown = false, startX, scrollLeft;

  track.addEventListener('mousedown', e => {
    isDown = true;
    track.classList.add('dragging');
    startX = e.pageX - track.offsetLeft;
    scrollLeft = track.scrollLeft;
  });
  track.addEventListener('mouseleave', () => {
    isDown = false;
    track.classList.remove('dragging');
  });
  track.addEventListener('mouseup', () => {
    isDown = false;
    track.classList.remove('dragging');
  });
  track.addEventListener('mousemove', e => {
    if (!isDown) return;
    e.preventDefault();
    const x = e.pageX - track.offsetLeft;
    const walk = (x - startX) * 1.5;
    track.scrollLeft = scrollLeft - walk;
  });

  // 觸控
  let touchStartX = 0;
  track.addEventListener('touchstart', e => {
    touchStartX = e.touches[0].pageX;
    scrollLeft = track.scrollLeft;
  }, { passive: true });
  track.addEventListener('touchmove', e => {
    const touchX = e.touches[0].pageX;
    const delta = touchX - touchStartX;
    track.scrollLeft = scrollLeft - delta;
  }, { passive: true });
})();

// 左右箭頭按鈕
const track2 = document.querySelector('.thumb-track');
const prevBtn = document.querySelector('.thumb-nav.prev');
const nextBtn = document.querySelector('.thumb-nav.next');
if (track2 && prevBtn && nextBtn) {
  prevBtn.addEventListener('click', () => track2.scrollBy({ left: -220, behavior: 'smooth' }));
  nextBtn.addEventListener('click', () => track2.scrollBy({ left: 220, behavior: 'smooth' }));
}
